/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.ventas;

import ec.gob.sri.dimm.api.ui.asistentes.AsistenteBase;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.ComprobanteVenta;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Venta;
import ec.gob.sri.dimm.ats.modelo.validator.rule.VentasValidationRule;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.ventas.PaginaComprobanteVenta;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.ventas.PaginaFormasDeCobro;
import java.util.AbstractMap;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;

public class AsistenteNuevoComprobanteVenta
extends AsistenteBase
implements INewWizard {
    public static final String ID = "ec.gob.sri.dimm.ats.ui.asistentes.ventas.AsistenteNuevoComprobanteVenta";
    private PaginaComprobanteVenta paginaComprobanteVenta;
    private PaginaFormasDeCobro formasDeCobro;
    private final ComprobanteVenta modeloDatos;
    private final Periodo periodo;
    private boolean esNotaDeCredito;
    private final List<AbstractMap.SimpleEntry<String, String>> comprobantesExistentes;

    public AsistenteNuevoComprobanteVenta(ComprobanteVenta comprobanteVenta, List<AbstractMap.SimpleEntry<String, String>> comprobantesExistentes) {
        this.modeloDatos = comprobanteVenta;
        this.comprobantesExistentes = comprobantesExistentes;
        this.periodo = ((Iva)((Venta)comprobanteVenta.getPropietario()).getPropietario()).periodo;
        this.setForcePreviousAndNextButtons(this.periodo.isAnexoEnPeriodoDesdeMayo2016());
    }

    public void addPages() {
        this.paginaComprobanteVenta = new PaginaComprobanteVenta(false, this.periodo, this.comprobantesExistentes);
        this.paginaComprobanteVenta.setModeloDatos(this.modeloDatos);
        this.paginaComprobanteVenta.inicializarModeloValores();
        this.formasDeCobro = new PaginaFormasDeCobro(this.periodo);
        this.formasDeCobro.setWizard((IWizard)this);
        this.formasDeCobro.setModeloDatos(this.modeloDatos);
        this.formasDeCobro.inicializarModeloValores();
        this.formasDeCobro.setPageComplete(false);
        this.addPage((IWizardPage)this.paginaComprobanteVenta);
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        this.esNotaDeCredito = VentasValidationRule.esNotaDeCreditoEnVentas((ComprobanteVenta)this.modeloDatos);
        if (currentPage instanceof PaginaComprobanteVenta) {
            return currentPage.isPageComplete() && (!this.periodo.isAnexoEnPeriodoDesdeJunio2016() || this.esNotaDeCredito);
        }
        if (currentPage instanceof PaginaFormasDeCobro) {
            return currentPage.isPageComplete();
        }
        return super.canFinish();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        this.esNotaDeCredito = VentasValidationRule.esNotaDeCreditoEnVentas((ComprobanteVenta)this.modeloDatos);
        if (page.equals((Object)this.paginaComprobanteVenta) && this.periodo.isAnexoEnPeriodoDesdeJunio2016() && !this.esNotaDeCredito) {
            return this.formasDeCobro;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page.equals((Object)this.formasDeCobro)) {
            return this.paginaComprobanteVenta;
        }
        return super.getPreviousPage(page);
    }

    public boolean performFinish() {
        return true;
    }
}

